/*
 * File:    AreaOfCircle_UserInput.java
 * Purpose: Calculates the area of a circle by asking the user how big the radius is.
 * Author:  William Paul Liggett
 */
package areaofcircle;

// The "Scanner" class accepts keyboard input as it will `scan the keyboard for data sent'.
import java.util.Scanner;

public class AreaOfCircle_UserInput {

    public static void main(String[] args) {
        // Sequential Programming: The program works by walking through line-by-line and nothing else.
        System.out.println("\n------------------------------------");  // The \n means to add a new line.
        System.out.println(" Area of a Circle: With User Input! ");
        System.out.println("------------------------------------");
        
        // --------------------------
        // MATH FORMULA
        // Area of a Circle = Pi(r^2)
        // --------------------------
        //
        // So, we need to ask the user for the size of the radius from the user.
        // To grab the user's input from the keyboard, we'll use the Scanner class.
        Scanner keyboard = new Scanner(System.in);
        
        // Here we are just defining that we want a variable called `radius' created that uses the `double' data type (decimal #).
        double radius;
        
        // Now, we'll ask the user to input a number for the circle's radius.
        // Notice that I am using the print() method and not println() [print line] since I don't want a new line after the ? mark.
        System.out.print("What is the radius of the circle? ");
        
        // Next, we use that "userInput" Scanner capability to grab data from the keyboard.
        // It waits for the user to press enter.
        // The .nextDouble() thing is a method [function] that stores the user data as a double (numeric) data type.
        radius = keyboard.nextDouble();
        
        // Note #1: The value of Pi is 3.14..., which Java has a built-in constant called Math.PI
        // Note #2: The Math.pow() method is for when dealing with exponents. The usage is Math.pow(x, y) for x^y.
        double area_of_circle = Math.PI * Math.pow(radius, 2);
        System.out.println("Area: " + area_of_circle + " units squared\n");  // The \n means to add a new line.
    }
    
}
